/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/** 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 11, 2003
 * Title : JavaBean.XmlGenerator.java
 * Desprition : This JavaBean class is responsible for processing request initiated 
 * from the related jsp pages and validating the inputs by using classes Validators.*
 * 
 */

/**Imported classes and packages */

package XmlCommunication;
import java.io.*;
import java.util.*;
import nz.co.cks.tms.xml.*;
import nz.co.cks.tms.xml.types.*;
import JavaBeans.*;
import java.math.*;

/**
 * @author student
 *
 * This class is being used for compiling xml packets using the classes
 * generated by Castor.
 * 
 */
public class XmlGenerator {
	private static int counter = 1;
	
	
	/**
	 * This is the constructor for XmlGenerator.java
	 */
	public XmlGenerator(){
	}
	
	
	/**
	 * This method is being used for the compilation of an admin add
	 * xml packet, which adds a new ncb to the TMS.
	 * @param customer Customer details that are to be added to TMS.
	 * @param address Address details that are to be added to TMS.
	 * @return String The xml message representing admin add.
	 */
	public String adminAddXml(
		Customer_Data customer,
		Address_Data address) {

		try {
			StringWriter writer = new StringWriter();
			System.out.println("XmlGenerator adminAddXml Started...");

			/** Initialise **/
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageAdminBlk madminb = new MessageAdminBlk();
			MessageTypeChoice mtc2 = new MessageTypeChoice(); //not needed?
			AdminAdd aa = new AdminAdd();
			Ncb ncb = new Ncb();

			NcbService ncbservice = new NcbService();

			NcbAddress ncbaddress = new NcbAddress();

			NcbTypeType ncbtypetype = NcbTypeType.valueOf("Person");

			/** set simpleTypes **/

			ncb.setNcbType(ncbtypetype);

			//Adding  new customer
			/** set simpleTypes **/
			//ncb.setParentNcbId(200);
			ncb.setNcbType(ncbtypetype);
			ncb.setName(customer.getFirstName());
			ncb.setNameLast(customer.getLastName());
			ncb.setLogin(customer.getUserName()); //generated login.
			ncb.setPassword(customer.getPassword());

			Attrib att = new Attrib();
			att.setName("CoffeePurchasing");
			att.setValue("CoffeePurchasing");
			ncbservice.addAttrib(att);
			ncbservice.setServiceCode("CoffeeServiceCode");

			NcbAddressTypeType ncbaddresstypetype =
				NcbAddressTypeType.valueOf("Delivery");
			ncbaddress.setSelectedAddressType(ncbaddresstypetype);
			ncbaddress.setCity(address.getCity());
			ncbaddress.setStreetLine1(
				address.getOffice()
					+ ","
					+ address.getFloor()
					+ ","
					+ address.getBuilding());
			ncbaddress.setStreetLine2(address.getStreet());
			ncbaddress.setCity(address.getCity());
			ncbaddress.setEmail(address.getEmail());
			ncbaddress.setPhoneNumber(address.getPhoneNumber());

			/** Add to parent **/
			aa.setNcb(ncb);
			aa.addNcbService(ncbservice);
			aa.addNcbAddress(ncbaddress);
			madminb.setAdminAdd(aa);
			mtc.setMessageAdminBlk(madminb);
			tmsMessage.setMessageTypeChoice(mtc); //adding choice.

			/** Set attributes **/
			mab.setNcbId(customer.getNcbId()); //for adding new customer
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet **/
			tmsMessage.marshal(writer);

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}

	}

	
	/**
	 * This method is being used for the compilation of admin update xml
	 * oacket which is used to update a given ncb.
	 * @param customer The customer details that are to be updated in TMS.
	 * @param address The address details that are being updated in TMS.
	 * @return String The xml string representing the admin update xml
	 * message.
	 */
	public String adminUpdateXml(
		Customer_Data customer,
		Address_Data address) {
		try {
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise **/
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageAdminBlk madminb = new MessageAdminBlk();
			MessageTypeChoice mtc2 = new MessageTypeChoice(); //not needed?
			AdminUpdate au = new AdminUpdate();
			Ncb ncb = new Ncb();

			NcbService ncbservice = new NcbService();
			Attrib att = new Attrib();
			att.setName("CoffeePurchasing");
			att.setValue("CoffeePurchasing");

			/** set simpleTypes **/
			ncb.setNcbId(customer.getNcbId());
			ncb.setName(customer.getFirstName());
			ncb.setNameLast(customer.getLastName());
			ncb.setLogin(customer.getUserName()); //generate the login.
			ncb.setPassword(customer.getPassword());

			ncbservice.addAttrib(att);
			ncbservice.setServiceCode("CoffeeServiceCode");

			NcbAddress ncbaddress = new NcbAddress();
			NcbAddressTypeType ncbaddresstypetype =
				NcbAddressTypeType.valueOf("Delivery");
			ncbaddress.setSelectedAddressType(ncbaddresstypetype);
			ncbaddress.setCity(address.getCity());
			ncbaddress.setStreetLine1(
				address.getOffice()
					+ ","
					+ address.getFloor()
					+ ","
					+ address.getBuilding());
			ncbaddress.setStreetLine2(address.getStreet());
			ncbaddress.setCity(address.getCity());
			ncbaddress.setEmail(address.getEmail());
			ncbaddress.setPhoneNumber(address.getPhoneNumber());

			/** Add to parent **/
			au.setNcb(ncb);
			au.addNcbService(ncbservice);
			au.addNcbAddress(ncbaddress);
			madminb.setAdminUpdate(au);
			mtc.setMessageAdminBlk(madminb);
			tmsMessage.setMessageTypeChoice(mtc); //adding choice.

			/** Set attributes **/
			mab.setNcbId(customer.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			System.out.println(Calendar.DATE);
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet **/
			tmsMessage.marshal(writer);

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}

	}

	
	/**
	 * This method is being used for compilation of transactionAuth Xml
	 * packet which is used to authenticate a customer's credit account
	 * and sets up an account with TMS.
	 * @param customer Customer details that are used for authorising
	 * the transaction.
	 * @param card Credit card details that are used for authorisation of
	 * the transaction. 
	 * @return String The xml string representing the transaction auth.
	 */
	public String transactionAuthXml(
		Customer_Data customer,
		CreditCard_Data card) {
		try {
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise **/
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageTransactionBlk mtransb = new MessageTransactionBlk();
			TransactionAuth ta = new TransactionAuth();
			CardInfo ci = new CardInfo();

			/** set simpleTypes **/
			ci.setCardName(card.getCardType());
			ci.setCardHolderName(card.getCardHolderName());
			ci.setCardNumber(card.getCardNumber());
			ci.setExpiryDate(card.getExpiryDate());

			BigDecimal bd = new BigDecimal(customer.getPreBillingAmount());
			ta.setPaymentAmount(bd);
			ta.setPaymentCurrencyCode("NZD"); //refer to technical docs..
			ta.setNcbId(customer.getNcbId());

			/** Add to parent **/
			ta.setCardInfo(ci);
			mtransb.setTransactionAuth(ta);
			mtc.setMessageTransactionBlk(mtransb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes **/
			mab.setNcbId(customer.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet **/
			tmsMessage.marshal(writer);

			return writer.toString();

		} catch (Exception e) {

			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}
	
	/**
	 * This method is being used for the compilation of transaction purchase
	 * xml packet which is used to identify a purchase order.
	 * @param customer Customer details that are used for transaction purchase. 
	 * @param address Address details that are used for transaction purchase.
	 * @param preference Coffee preference details that are used for the transaction
	 * purchase.
	 * @param coffee Coffee details that used for the transaction purchase.
	 * @return String The xml string that represents the trnsaction purchase.
	 */
	public String transactionPurchaseXml(
		Customer_Data customer,
		Address_Data address,
		CoffeePreference_Data preference,
		Coffee_Data coffee) {
		try {
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise */
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageTransactionBlk mtransb = new MessageTransactionBlk();
			TransactionPurchase tp = new TransactionPurchase();

			Ncb ncb = new Ncb();
			NcbAddress ncbaddress = new NcbAddress();
			NcbAddressTypeType ncbaddresstypetype =
				NcbAddressTypeType.valueOf("Delivery");
			PurchaseItem pi = new PurchaseItem();

			/** set simpleTypes */
			pi.setItemCode(coffee.getItemCode());
			pi.setItemQuantity(Integer.parseInt(preference.getQuantity()));
			pi.setServiceCode(coffee.getServiceCode());
			pi.setServiceRequest(coffee.getServiceRequest());
			pi.setServiceResponse(coffee.getServiceResponse());

			ncb.setNcbId(customer.getNcbId());
			ncb.setName(customer.getFirstName());

			/** Add to parent */
			tp.setNcb(ncb);
			tp.addPurchaseItem(pi);
			tp.setPaymentCurrencyCode("NZD");

			mtransb.setTransactionPurchase(tp);
			mtc.setMessageTransactionBlk(mtransb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes */
			mab.setNcbId(customer.getNcbId());

			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet */
			tmsMessage.marshal(writer);

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}
	
	/**
	 * This method is being used for the compilation of transaction settlement
	 * xml packet which asks for the confirmation of the transaction.
	 * @param customer Customer details that are being used for the transaction
	 * settlement.
	 * @param card Credit card details that are being used for the transaction 
	 * settlement.
	 * @param preference Coffee preference details that are being used for the 
	 * transaction settlement.
	 * @param coffee Coffee details that are being used for the transaction 
	 * settlement.
	 * @return String The xml string representing the transaction settlement.
	 */
	public String transactionSettlementXml(
		Customer_Data customer,
		CreditCard_Data card,
		CoffeePreference_Data preference,
		Coffee_Data coffee) {
		try {
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise */
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageTransactionBlk mtransb = new MessageTransactionBlk();
			TransactionSettlement ts = new TransactionSettlement();

			/** set simpleTypes */
			double d =
				(Integer.parseInt(preference.getQuantity())
					* coffee.getPrice());
			String str = String.valueOf(d);

			BigDecimal bd = new BigDecimal(str);
			ts.setPaymentAmount(bd);
			ts.setPaymentCurrencyCode("NZD"); //refer to technical docs..
			ts.setNcbId(customer.getNcbId());

			/** Add to parent */
			mtransb.setTransactionSettlement(ts);
			mtc.setMessageTransactionBlk(mtransb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes */
			mab.setNcbId(customer.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet */
			tmsMessage.marshal(writer);

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}
	
	/**
	 * This method is being used for the compilation of enquiry ncb xml
	 * packet which gets the given ncb's data from TMS.
	 * @param customer Customer details for whom enquiry ncb is being sent.
	 * @param card Credit card details that are used for the enquiry ncb.
	 * @return String The xml string that represents theenquiry ncb.
	 */
	public String enquiryNcbXml(
		Customer_Data customer,
		CreditCard_Data card) {
		try {
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise */
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageEnquiryBlk menquiryb = new MessageEnquiryBlk();
			//MessageTypeChoice mtc2 = new MessageTypeChoice(); //not needed?
			EnquiryNcb en = new EnquiryNcb();

			/** set simpleTypes */
			en.setNcbId(customer.getNcbId());

			/** Add to parent */
			menquiryb.setEnquiryNcb(en);
			mtc.setMessageEnquiryBlk(menquiryb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes */
			mab.setNcbId(customer.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet */
			tmsMessage.marshal(writer);
			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}
	
	/**
	 * This method is being used for the compilation of enquiry ncb
	 * address xml which is used to get the address data of the 
	 * specified ncb from TMS.
	 * @param customer Customer details that are being used for enquiry
	 * ncb address.
	 * @param card The credit card details that are being used for enquiry
	 * ncb address.
	 * @return String The xml string that represents enquiry ncb address.
	 */
	public String enquiryNcbAddressXml(
		Customer_Data customer,
		CreditCard_Data card) {
		try {
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise */
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageEnquiryBlk menquiryb = new MessageEnquiryBlk();
			EnquiryNcbAddress ena = new EnquiryNcbAddress();

			NcbAddress na = new NcbAddress();
			NcbAddressTypeType ncbaddresstypetype =
				NcbAddressTypeType.valueOf("Delivery");

			/** set simpleTypes */
			na.setSelectedAddressType(ncbaddresstypetype);

			ena.setNcbId(customer.getNcbId());

			/** Add to parent */
			ena.addNcbAddress(na);
			menquiryb.setEnquiryNcbAddress(ena);
			mtc.setMessageEnquiryBlk(menquiryb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes */
			mab.setNcbId(customer.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet */
			tmsMessage.marshal(writer);
			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}

}
